--[[---------------------------------------------------------------------------
	Chocolatier Two Map UI
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local portLabelFont = { standardFontName, kEighteen, DefaultColor }

-- Layout constants
local kPortIconSpacing = 13	--15
local kPortIconRadius = 17

-- Active travel disabler
gTravelActive = nil

-------------------------------------------------------------------------------
-- Gather port labels and icons

local portLabels = {}
local portIcons = {}

for port in LPort:AllPorts() do
	-- Determine the positioning of the travel tag popup
	local yOffset = -ui.travelTagHeight/2
	local xOffset = 0
	
	-- Flip tag if it hits the right edge of the screen
	if port.mapx + ui.travelTagWidth >= ui.screenWidth then
		xOffset = -ui.travelTagWidth
	end

	-- Determine the icon to use
	local mapx = port.mapx - kPortIconRadius
	local mapy = port.mapy - kPortIconRadius
	if (port == gSim.port) then
		table.insert(portIcons, Bitmap { x=mapx,y=mapy,image="image/port_current", })
	end
	local shiftLabel = false
	if port.available or not port.hidden then
		local x=mapx
		local y=mapy
		local icon = "image/port_unavailable"
		
		if port.factoryOwned then
			icon = "image/factory.xml"
			local f = LFactory:ByPort(port.name)
			if f and f.idle then icon = "image/factory_idle.xml" end
			shiftLabel = true
		elseif port.shopOwned then
			icon = "image/icon_shop"
			shiftLabel = true
		elseif port.labOwned then
			icon = "image/icon_lab"
			shiftLabel = true
		elseif port.available then
			if port.visited then
				icon = "image/port_available"
			elseif port.hidden then
				icon = "image/secret_port_new.xml"
			else
				icon = "image/port_new.xml"
			end
		end
		
		local port = port	-- for function closure
		table.insert(portIcons, 
			Rollover
			{
				x=mapx+1,y=mapy-6,w=kPortIconRadius,h=kPortIconRadius,
				xAbsolute = port.mapx + xOffset + ui.xOffset, yAbsolute = port.mapy + yOffset + ui.yOffset,
				contents = port:RolloverTarget(),
				command = function()
					if port.available and not gTravelActive then
						EnableWindow("to_port",false)
						EnableWindow("to_port_label",false)
						if gSim.port == port then
							gSim:EnterPort()
						elseif not gSim:TravelTo(port) then
							EnableWindow("to_port",true)
							EnableWindow("to_port_label",true)
						end
					end
				end,
				Sprite { x=kPortIconRadius,y=kPortIconRadius, image=icon },
			})
	end

	-- Determine the label
	if port.available or not port.hidden then
		-- Position port label
		mapx = port.mapx
		mapy = port.mapy
		local flags = port.labelpos
		if flags == kHAlignLeft then
			if shiftLabel then mapx = mapx - 151
			else mapx = mapx - 145
			end
			mapy = mapy - 10
			flags = kHAlignRight + kVAlignCenter
		elseif flags == kVAlignBottom then
			mapx = mapx - 75
			mapy = mapy + 10
			flags = kHAlignCenter + kVAlignTop
		else
			if shiftLabel then mapx = mapx + kPortIconSpacing
			else mapx = mapx + 3
			end
			mapy = mapy - 10
			flags = kHAlignLeft + kVAlignCenter
		end
		if mapx < 0 then mapx = 0 end
		if mapy < 0 then mapy = 0 end
		
		local s = "#<outline color='ffffff' size=1>" .. GetString(port.name)
		table.insert(portLabels, Text { x=mapx, y=mapy, w=140, h=20, label=s, flags=flags, font=portLabelFont })
	end
end

-------------------------------------------------------------------------------

MakeDialog
{
	bsgScreen
	{
		AppendStyle { ports=LPort._ByName, routes=gSim.port:GetRoutes(), current=gSim.port.name },
		Map
		{
			x=0,y=0,w=kMax,h=kMax,
			Bitmap { x=kCenter,y=kCenter, name = "map", image="image/map",
				Bitmap { x=0,y=0, name = "colormask", w=kMax,h=kMax, },
				Group(portIcons),
				Group(portLabels),
			},
		},
		MapTravel { x=0,y=0,w=kMax,h=kMax, xOffset=ui.xOffset, yOffset=ui.yOffset, },
		NormalLedger(),
	},
}

gViewMode = "map"
SetLedgerMode("map")
SetMusicState("normal")
gSim.port:SetAmbient()
bsgTriggerAd()		-- TOGETHER
